package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Name, BoxedBoolean}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DialogCodeHookInvocationSetting(
    enableCodeHookInvocation: BoxedBoolean,
    active: BoxedBoolean,
    invocationLabel: Optional[Name] = Optional.Absent,
    postCodeHookSpecification: zio.aws.lexmodelsv2.model.PostDialogCodeHookInvocationSpecification
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DialogCodeHookInvocationSetting = {
    import DialogCodeHookInvocationSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DialogCodeHookInvocationSetting
      .builder()
      .enableCodeHookInvocation(enableCodeHookInvocation: java.lang.Boolean)
      .active(active: java.lang.Boolean)
      .optionallyWith(
        invocationLabel.map(value => Name.unwrap(value): java.lang.String)
      )(_.invocationLabel)
      .postCodeHookSpecification(postCodeHookSpecification.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting
      .wrap(buildAwsValue())
}
object DialogCodeHookInvocationSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DialogCodeHookInvocationSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting =
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting(
        enableCodeHookInvocation,
        active,
        invocationLabel.map(value => value),
        postCodeHookSpecification.asEditable
      )
    def enableCodeHookInvocation: BoxedBoolean
    def active: BoxedBoolean
    def invocationLabel: Optional[Name]
    def postCodeHookSpecification
        : zio.aws.lexmodelsv2.model.PostDialogCodeHookInvocationSpecification.ReadOnly
    def getEnableCodeHookInvocation: ZIO[Any, Nothing, BoxedBoolean] =
      ZIO.succeed(enableCodeHookInvocation)
    def getActive: ZIO[Any, Nothing, BoxedBoolean] = ZIO.succeed(active)
    def getInvocationLabel: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("invocationLabel", invocationLabel)
    def getPostCodeHookSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.PostDialogCodeHookInvocationSpecification.ReadOnly
    ] = ZIO.succeed(postCodeHookSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DialogCodeHookInvocationSetting
  ) extends zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.ReadOnly {
    override val enableCodeHookInvocation: BoxedBoolean =
      impl.enableCodeHookInvocation(): BoxedBoolean
    override val active: BoxedBoolean = impl.active(): BoxedBoolean
    override val invocationLabel: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.invocationLabel())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val postCodeHookSpecification
        : zio.aws.lexmodelsv2.model.PostDialogCodeHookInvocationSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.PostDialogCodeHookInvocationSpecification
        .wrap(impl.postCodeHookSpecification())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DialogCodeHookInvocationSetting
  ): zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.ReadOnly =
    new Wrapper(impl)
}
