package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExportSortBy(
    attribute: zio.aws.lexmodelsv2.model.ExportSortAttribute,
    order: zio.aws.lexmodelsv2.model.SortOrder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ExportSortBy = {
    import ExportSortBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ExportSortBy
      .builder()
      .attribute(attribute.unwrap)
      .order(order.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ExportSortBy.ReadOnly =
    zio.aws.lexmodelsv2.model.ExportSortBy.wrap(buildAwsValue())
}
object ExportSortBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ExportSortBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ExportSortBy =
      zio.aws.lexmodelsv2.model.ExportSortBy(attribute, order)
    def attribute: zio.aws.lexmodelsv2.model.ExportSortAttribute
    def order: zio.aws.lexmodelsv2.model.SortOrder
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.ExportSortAttribute] =
      ZIO.succeed(attribute)
    def getOrder: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SortOrder] =
      ZIO.succeed(order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ExportSortBy
  ) extends zio.aws.lexmodelsv2.model.ExportSortBy.ReadOnly {
    override val attribute: zio.aws.lexmodelsv2.model.ExportSortAttribute =
      zio.aws.lexmodelsv2.model.ExportSortAttribute.wrap(impl.attribute())
    override val order: zio.aws.lexmodelsv2.model.SortOrder =
      zio.aws.lexmodelsv2.model.SortOrder.wrap(impl.order())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ExportSortBy
  ): zio.aws.lexmodelsv2.model.ExportSortBy.ReadOnly = new Wrapper(impl)
}
