package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SlotValueElicitationSetting(
    defaultValueSpecification: Optional[
      zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification
    ] = Optional.Absent,
    slotConstraint: zio.aws.lexmodelsv2.model.SlotConstraint,
    promptSpecification: Optional[
      zio.aws.lexmodelsv2.model.PromptSpecification
    ] = Optional.Absent,
    sampleUtterances: Optional[
      Iterable[zio.aws.lexmodelsv2.model.SampleUtterance]
    ] = Optional.Absent,
    waitAndContinueSpecification: Optional[
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification
    ] = Optional.Absent,
    slotCaptureSetting: Optional[zio.aws.lexmodelsv2.model.SlotCaptureSetting] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotValueElicitationSetting = {
    import SlotValueElicitationSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotValueElicitationSetting
      .builder()
      .optionallyWith(
        defaultValueSpecification.map(value => value.buildAwsValue())
      )(_.defaultValueSpecification)
      .slotConstraint(slotConstraint.unwrap)
      .optionallyWith(promptSpecification.map(value => value.buildAwsValue()))(
        _.promptSpecification
      )
      .optionallyWith(
        sampleUtterances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sampleUtterances)
      .optionallyWith(
        waitAndContinueSpecification.map(value => value.buildAwsValue())
      )(_.waitAndContinueSpecification)
      .optionallyWith(slotCaptureSetting.map(value => value.buildAwsValue()))(
        _.slotCaptureSetting
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.wrap(buildAwsValue())
}
object SlotValueElicitationSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotValueElicitationSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotValueElicitationSetting =
      zio.aws.lexmodelsv2.model.SlotValueElicitationSetting(
        defaultValueSpecification.map(value => value.asEditable),
        slotConstraint,
        promptSpecification.map(value => value.asEditable),
        sampleUtterances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        waitAndContinueSpecification.map(value => value.asEditable),
        slotCaptureSetting.map(value => value.asEditable)
      )
    def defaultValueSpecification: Optional[
      zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.ReadOnly
    ]
    def slotConstraint: zio.aws.lexmodelsv2.model.SlotConstraint
    def promptSpecification
        : Optional[zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly]
    def sampleUtterances
        : Optional[List[zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly]]
    def waitAndContinueSpecification: Optional[
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.ReadOnly
    ]
    def slotCaptureSetting
        : Optional[zio.aws.lexmodelsv2.model.SlotCaptureSetting.ReadOnly]
    def getDefaultValueSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultValueSpecification",
      defaultValueSpecification
    )
    def getSlotConstraint
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SlotConstraint] =
      ZIO.succeed(slotConstraint)
    def getPromptSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("promptSpecification", promptSpecification)
    def getSampleUtterances: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly
    ]] = AwsError.unwrapOptionField("sampleUtterances", sampleUtterances)
    def getWaitAndContinueSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "waitAndContinueSpecification",
      waitAndContinueSpecification
    )
    def getSlotCaptureSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SlotCaptureSetting.ReadOnly
    ] = AwsError.unwrapOptionField("slotCaptureSetting", slotCaptureSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotValueElicitationSetting
  ) extends zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly {
    override val defaultValueSpecification: Optional[
      zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValueSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.wrap(value)
      )
    override val slotConstraint: zio.aws.lexmodelsv2.model.SlotConstraint =
      zio.aws.lexmodelsv2.model.SlotConstraint.wrap(impl.slotConstraint())
    override val promptSpecification
        : Optional[zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promptSpecification())
        .map(value => zio.aws.lexmodelsv2.model.PromptSpecification.wrap(value))
    override val sampleUtterances
        : Optional[List[zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampleUtterances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.SampleUtterance.wrap(item)
          }.toList
        )
    override val waitAndContinueSpecification: Optional[
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.waitAndContinueSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.wrap(value)
      )
    override val slotCaptureSetting
        : Optional[zio.aws.lexmodelsv2.model.SlotCaptureSetting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slotCaptureSetting())
        .map(value => zio.aws.lexmodelsv2.model.SlotCaptureSetting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotValueElicitationSetting
  ): zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly =
    new Wrapper(impl)
}
