package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, BotVersion, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeIntentRequest(
    intentId: Id,
    botId: Id,
    botVersion: BotVersion,
    localeId: LocaleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest = {
    import DescribeIntentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest
      .builder()
      .intentId(Id.unwrap(intentId): java.lang.String)
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(BotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeIntentRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeIntentRequest.wrap(buildAwsValue())
}
object DescribeIntentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeIntentRequest =
      zio.aws.lexmodelsv2.model.DescribeIntentRequest(
        intentId,
        botId,
        botVersion,
        localeId
      )
    def intentId: Id
    def botId: Id
    def botVersion: BotVersion
    def localeId: LocaleId
    def getIntentId: ZIO[Any, Nothing, Id] = ZIO.succeed(intentId)
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, BotVersion] = ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest
  ) extends zio.aws.lexmodelsv2.model.DescribeIntentRequest.ReadOnly {
    override val intentId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.intentId())
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: BotVersion =
      zio.aws.lexmodelsv2.model.primitives.BotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest
  ): zio.aws.lexmodelsv2.model.DescribeIntentRequest.ReadOnly = new Wrapper(
    impl
  )
}
