package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, DraftBotVersion, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCustomVocabularyRequest(
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyRequest = {
    import DeleteCustomVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DeleteCustomVocabularyRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteCustomVocabularyRequest
      .wrap(buildAwsValue())
}
object DeleteCustomVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteCustomVocabularyRequest =
      zio.aws.lexmodelsv2.model
        .DeleteCustomVocabularyRequest(botId, botVersion, localeId)
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteCustomVocabularyRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyRequest
  ): zio.aws.lexmodelsv2.model.DeleteCustomVocabularyRequest.ReadOnly =
    new Wrapper(impl)
}
