package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.Count
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class IntentStatistics(
    discoveredIntentCount: Optional[Count] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentStatistics = {
    import IntentStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentStatistics
      .builder()
      .optionallyWith(
        discoveredIntentCount.map(value => Count.unwrap(value): Integer)
      )(_.discoveredIntentCount)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.IntentStatistics.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentStatistics.wrap(buildAwsValue())
}
object IntentStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.IntentStatistics =
      zio.aws.lexmodelsv2.model
        .IntentStatistics(discoveredIntentCount.map(value => value))
    def discoveredIntentCount: Optional[Count]
    def getDiscoveredIntentCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("discoveredIntentCount", discoveredIntentCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentStatistics
  ) extends zio.aws.lexmodelsv2.model.IntentStatistics.ReadOnly {
    override val discoveredIntentCount: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.discoveredIntentCount())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Count(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentStatistics
  ): zio.aws.lexmodelsv2.model.IntentStatistics.ReadOnly = new Wrapper(impl)
}
