package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MessageGroup(
    message: zio.aws.lexmodelsv2.model.Message,
    variations: Optional[Iterable[zio.aws.lexmodelsv2.model.Message]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup = {
    import MessageGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup
      .builder()
      .message(message.buildAwsValue())
      .optionallyWith(
        variations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.variations)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly =
    zio.aws.lexmodelsv2.model.MessageGroup.wrap(buildAwsValue())
}
object MessageGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.MessageGroup =
      zio.aws.lexmodelsv2.model.MessageGroup(
        message.asEditable,
        variations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def message: zio.aws.lexmodelsv2.model.Message.ReadOnly
    def variations: Optional[List[zio.aws.lexmodelsv2.model.Message.ReadOnly]]
    def getMessage
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.Message.ReadOnly] =
      ZIO.succeed(message)
    def getVariations
        : ZIO[Any, AwsError, List[zio.aws.lexmodelsv2.model.Message.ReadOnly]] =
      AwsError.unwrapOptionField("variations", variations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup
  ) extends zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly {
    override val message: zio.aws.lexmodelsv2.model.Message.ReadOnly =
      zio.aws.lexmodelsv2.model.Message.wrap(impl.message())
    override val variations
        : Optional[List[zio.aws.lexmodelsv2.model.Message.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.variations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.Message.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup
  ): zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly = new Wrapper(impl)
}
