package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  AnalyticsLongValue,
  BotAliasId,
  AnalyticsChannel,
  Timestamp,
  NumericalBotVersion,
  AnalyticsSessionId,
  AnalyticsOriginatingRequestId
}
import scala.jdk.CollectionConverters._
final case class SessionSpecification(
    botAliasId: Optional[BotAliasId] = Optional.Absent,
    botVersion: Optional[NumericalBotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    channel: Optional[AnalyticsChannel] = Optional.Absent,
    sessionId: Optional[AnalyticsSessionId] = Optional.Absent,
    conversationStartTime: Optional[Timestamp] = Optional.Absent,
    conversationEndTime: Optional[Timestamp] = Optional.Absent,
    conversationDurationSeconds: Optional[AnalyticsLongValue] = Optional.Absent,
    conversationEndState: Optional[
      zio.aws.lexmodelsv2.model.ConversationEndState
    ] = Optional.Absent,
    mode: Optional[zio.aws.lexmodelsv2.model.AnalyticsModality] =
      Optional.Absent,
    numberOfTurns: Optional[AnalyticsLongValue] = Optional.Absent,
    invokedIntentSamples: Optional[
      Iterable[zio.aws.lexmodelsv2.model.InvokedIntentSample]
    ] = Optional.Absent,
    originatingRequestId: Optional[AnalyticsOriginatingRequestId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SessionSpecification = {
    import SessionSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SessionSpecification
      .builder()
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(
        botVersion.map(value =>
          NumericalBotVersion.unwrap(value): java.lang.String
        )
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        channel.map(value => AnalyticsChannel.unwrap(value): java.lang.String)
      )(_.channel)
      .optionallyWith(
        sessionId.map(value =>
          AnalyticsSessionId.unwrap(value): java.lang.String
        )
      )(_.sessionId)
      .optionallyWith(
        conversationStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.conversationStartTime)
      .optionallyWith(
        conversationEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.conversationEndTime)
      .optionallyWith(
        conversationDurationSeconds.map(value =>
          AnalyticsLongValue.unwrap(value): java.lang.Long
        )
      )(_.conversationDurationSeconds)
      .optionallyWith(conversationEndState.map(value => value.unwrap))(
        _.conversationEndState
      )
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        numberOfTurns.map(value =>
          AnalyticsLongValue.unwrap(value): java.lang.Long
        )
      )(_.numberOfTurns)
      .optionallyWith(
        invokedIntentSamples.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.invokedIntentSamples)
      .optionallyWith(
        originatingRequestId.map(value =>
          AnalyticsOriginatingRequestId.unwrap(value): java.lang.String
        )
      )(_.originatingRequestId)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SessionSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.SessionSpecification.wrap(buildAwsValue())
}
object SessionSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SessionSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SessionSpecification =
      zio.aws.lexmodelsv2.model.SessionSpecification(
        botAliasId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        channel.map(value => value),
        sessionId.map(value => value),
        conversationStartTime.map(value => value),
        conversationEndTime.map(value => value),
        conversationDurationSeconds.map(value => value),
        conversationEndState.map(value => value),
        mode.map(value => value),
        numberOfTurns.map(value => value),
        invokedIntentSamples.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        originatingRequestId.map(value => value)
      )
    def botAliasId: Optional[BotAliasId]
    def botVersion: Optional[NumericalBotVersion]
    def localeId: Optional[LocaleId]
    def channel: Optional[AnalyticsChannel]
    def sessionId: Optional[AnalyticsSessionId]
    def conversationStartTime: Optional[Timestamp]
    def conversationEndTime: Optional[Timestamp]
    def conversationDurationSeconds: Optional[AnalyticsLongValue]
    def conversationEndState
        : Optional[zio.aws.lexmodelsv2.model.ConversationEndState]
    def mode: Optional[zio.aws.lexmodelsv2.model.AnalyticsModality]
    def numberOfTurns: Optional[AnalyticsLongValue]
    def invokedIntentSamples
        : Optional[List[zio.aws.lexmodelsv2.model.InvokedIntentSample.ReadOnly]]
    def originatingRequestId: Optional[AnalyticsOriginatingRequestId]
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotVersion: ZIO[Any, AwsError, NumericalBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getChannel: ZIO[Any, AwsError, AnalyticsChannel] =
      AwsError.unwrapOptionField("channel", channel)
    def getSessionId: ZIO[Any, AwsError, AnalyticsSessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getConversationStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("conversationStartTime", conversationStartTime)
    def getConversationEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("conversationEndTime", conversationEndTime)
    def getConversationDurationSeconds: ZIO[Any, AwsError, AnalyticsLongValue] =
      AwsError.unwrapOptionField(
        "conversationDurationSeconds",
        conversationDurationSeconds
      )
    def getConversationEndState
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ConversationEndState] =
      AwsError.unwrapOptionField("conversationEndState", conversationEndState)
    def getMode
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.AnalyticsModality] =
      AwsError.unwrapOptionField("mode", mode)
    def getNumberOfTurns: ZIO[Any, AwsError, AnalyticsLongValue] =
      AwsError.unwrapOptionField("numberOfTurns", numberOfTurns)
    def getInvokedIntentSamples: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.InvokedIntentSample.ReadOnly
    ]] =
      AwsError.unwrapOptionField("invokedIntentSamples", invokedIntentSamples)
    def getOriginatingRequestId
        : ZIO[Any, AwsError, AnalyticsOriginatingRequestId] =
      AwsError.unwrapOptionField("originatingRequestId", originatingRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SessionSpecification
  ) extends zio.aws.lexmodelsv2.model.SessionSpecification.ReadOnly {
    override val botAliasId: Optional[BotAliasId] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botVersion: Optional[NumericalBotVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botVersion())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.NumericalBotVersion(value)
        )
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val channel: Optional[AnalyticsChannel] = zio.aws.core.internal
      .optionalFromNullable(impl.channel())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AnalyticsChannel(value)
      )
    override val sessionId: Optional[AnalyticsSessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AnalyticsSessionId(value)
      )
    override val conversationStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationStartTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val conversationEndTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationEndTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val conversationDurationSeconds: Optional[AnalyticsLongValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationDurationSeconds())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.AnalyticsLongValue(value)
        )
    override val conversationEndState
        : Optional[zio.aws.lexmodelsv2.model.ConversationEndState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationEndState())
        .map(value =>
          zio.aws.lexmodelsv2.model.ConversationEndState.wrap(value)
        )
    override val mode: Optional[zio.aws.lexmodelsv2.model.AnalyticsModality] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.lexmodelsv2.model.AnalyticsModality.wrap(value))
    override val numberOfTurns: Optional[AnalyticsLongValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfTurns())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.AnalyticsLongValue(value)
        )
    override val invokedIntentSamples: Optional[
      List[zio.aws.lexmodelsv2.model.InvokedIntentSample.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.invokedIntentSamples())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.InvokedIntentSample.wrap(item)
        }.toList
      )
    override val originatingRequestId: Optional[AnalyticsOriginatingRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originatingRequestId())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives
            .AnalyticsOriginatingRequestId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SessionSpecification
  ): zio.aws.lexmodelsv2.model.SessionSpecification.ReadOnly = new Wrapper(impl)
}
