package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.TimeValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RelativeAggregationDuration(
    timeDimension: zio.aws.lexmodelsv2.model.TimeDimension,
    timeValue: TimeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.RelativeAggregationDuration = {
    import RelativeAggregationDuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.RelativeAggregationDuration
      .builder()
      .timeDimension(timeDimension.unwrap)
      .timeValue(TimeValue.unwrap(timeValue): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.RelativeAggregationDuration.ReadOnly =
    zio.aws.lexmodelsv2.model.RelativeAggregationDuration.wrap(buildAwsValue())
}
object RelativeAggregationDuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.RelativeAggregationDuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.RelativeAggregationDuration =
      zio.aws.lexmodelsv2.model
        .RelativeAggregationDuration(timeDimension, timeValue)
    def timeDimension: zio.aws.lexmodelsv2.model.TimeDimension
    def timeValue: TimeValue
    def getTimeDimension
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.TimeDimension] =
      ZIO.succeed(timeDimension)
    def getTimeValue: ZIO[Any, Nothing, TimeValue] = ZIO.succeed(timeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.RelativeAggregationDuration
  ) extends zio.aws.lexmodelsv2.model.RelativeAggregationDuration.ReadOnly {
    override val timeDimension: zio.aws.lexmodelsv2.model.TimeDimension =
      zio.aws.lexmodelsv2.model.TimeDimension.wrap(impl.timeDimension())
    override val timeValue: TimeValue =
      zio.aws.lexmodelsv2.model.primitives.TimeValue(impl.timeValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.RelativeAggregationDuration
  ): zio.aws.lexmodelsv2.model.RelativeAggregationDuration.ReadOnly =
    new Wrapper(impl)
}
