package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.AnalyticsGroupByValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalyticsUtteranceGroupByKey(
    name: Optional[zio.aws.lexmodelsv2.model.AnalyticsUtteranceField] =
      Optional.Absent,
    value: Optional[AnalyticsGroupByValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceGroupByKey = {
    import AnalyticsUtteranceGroupByKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceGroupByKey
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value =>
          AnalyticsGroupByValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AnalyticsUtteranceGroupByKey.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsUtteranceGroupByKey.wrap(buildAwsValue())
}
object AnalyticsUtteranceGroupByKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceGroupByKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsUtteranceGroupByKey =
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceGroupByKey(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[zio.aws.lexmodelsv2.model.AnalyticsUtteranceField]
    def value: Optional[AnalyticsGroupByValue]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceField
    ] = AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, AnalyticsGroupByValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceGroupByKey
  ) extends zio.aws.lexmodelsv2.model.AnalyticsUtteranceGroupByKey.ReadOnly {
    override val name
        : Optional[zio.aws.lexmodelsv2.model.AnalyticsUtteranceField] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.lexmodelsv2.model.AnalyticsUtteranceField.wrap(value)
        )
    override val value: Optional[AnalyticsGroupByValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AnalyticsGroupByValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceGroupByKey
  ): zio.aws.lexmodelsv2.model.AnalyticsUtteranceGroupByKey.ReadOnly =
    new Wrapper(impl)
}
