package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalyticsBinBySpecification(
    name: zio.aws.lexmodelsv2.model.AnalyticsBinByName,
    interval: zio.aws.lexmodelsv2.model.AnalyticsInterval,
    order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinBySpecification = {
    import AnalyticsBinBySpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinBySpecification
      .builder()
      .name(name.unwrap)
      .interval(interval.unwrap)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification.wrap(buildAwsValue())
}
object AnalyticsBinBySpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinBySpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification =
      zio.aws.lexmodelsv2.model
        .AnalyticsBinBySpecification(name, interval, order.map(value => value))
    def name: zio.aws.lexmodelsv2.model.AnalyticsBinByName
    def interval: zio.aws.lexmodelsv2.model.AnalyticsInterval
    def order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder]
    def getName
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.AnalyticsBinByName] =
      ZIO.succeed(name)
    def getInterval
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.AnalyticsInterval] =
      ZIO.succeed(interval)
    def getOrder
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      AwsError.unwrapOptionField("order", order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinBySpecification
  ) extends zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.AnalyticsBinByName =
      zio.aws.lexmodelsv2.model.AnalyticsBinByName.wrap(impl.name())
    override val interval: zio.aws.lexmodelsv2.model.AnalyticsInterval =
      zio.aws.lexmodelsv2.model.AnalyticsInterval.wrap(impl.interval())
    override val order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.order())
        .map(value => zio.aws.lexmodelsv2.model.AnalyticsSortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinBySpecification
  ): zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification.ReadOnly =
    new Wrapper(impl)
}
