package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserTurnInputSpecification(
    utteranceInput: zio.aws.lexmodelsv2.model.UtteranceInputSpecification,
    requestAttributes: Optional[Map[NonEmptyString, String]] = Optional.Absent,
    sessionState: Optional[
      zio.aws.lexmodelsv2.model.InputSessionStateSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UserTurnInputSpecification = {
    import UserTurnInputSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UserTurnInputSpecification
      .builder()
      .utteranceInput(utteranceInput.buildAwsValue())
      .optionallyWith(
        requestAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString
                .unwrap(key): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestAttributes)
      .optionallyWith(sessionState.map(value => value.buildAwsValue()))(
        _.sessionState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.UserTurnInputSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.UserTurnInputSpecification.wrap(buildAwsValue())
}
object UserTurnInputSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UserTurnInputSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UserTurnInputSpecification =
      zio.aws.lexmodelsv2.model.UserTurnInputSpecification(
        utteranceInput.asEditable,
        requestAttributes.map(value => value),
        sessionState.map(value => value.asEditable)
      )
    def utteranceInput
        : zio.aws.lexmodelsv2.model.UtteranceInputSpecification.ReadOnly
    def requestAttributes: Optional[Map[NonEmptyString, String]]
    def sessionState: Optional[
      zio.aws.lexmodelsv2.model.InputSessionStateSpecification.ReadOnly
    ]
    def getUtteranceInput: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.UtteranceInputSpecification.ReadOnly
    ] = ZIO.succeed(utteranceInput)
    def getRequestAttributes: ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
    def getSessionState: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.InputSessionStateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("sessionState", sessionState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UserTurnInputSpecification
  ) extends zio.aws.lexmodelsv2.model.UserTurnInputSpecification.ReadOnly {
    override val utteranceInput
        : zio.aws.lexmodelsv2.model.UtteranceInputSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.UtteranceInputSpecification
        .wrap(impl.utteranceInput())
    override val requestAttributes: Optional[Map[NonEmptyString, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestAttributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lexmodelsv2.model.primitives
                .NonEmptyString(key) -> (value: String)
            })
            .toMap
        )
    override val sessionState: Optional[
      zio.aws.lexmodelsv2.model.InputSessionStateSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionState())
      .map(value =>
        zio.aws.lexmodelsv2.model.InputSessionStateSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UserTurnInputSpecification
  ): zio.aws.lexmodelsv2.model.UserTurnInputSpecification.ReadOnly =
    new Wrapper(impl)
}
