package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  RoleArn,
  TagValue,
  Description,
  Name,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestSetImportResourceSpecification(
    testSetName: Name,
    description: Optional[Description] = Optional.Absent,
    roleArn: RoleArn,
    storageLocation: zio.aws.lexmodelsv2.model.TestSetStorageLocation,
    importInputLocation: zio.aws.lexmodelsv2.model.TestSetImportInputLocation,
    modality: zio.aws.lexmodelsv2.model.TestSetModality,
    testSetTags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetImportResourceSpecification = {
    import TestSetImportResourceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetImportResourceSpecification
      .builder()
      .testSetName(Name.unwrap(testSetName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .storageLocation(storageLocation.buildAwsValue())
      .importInputLocation(importInputLocation.buildAwsValue())
      .modality(modality.unwrap)
      .optionallyWith(
        testSetTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.testSetTags)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.TestSetImportResourceSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetImportResourceSpecification
      .wrap(buildAwsValue())
}
object TestSetImportResourceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetImportResourceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.TestSetImportResourceSpecification =
      zio.aws.lexmodelsv2.model.TestSetImportResourceSpecification(
        testSetName,
        description.map(value => value),
        roleArn,
        storageLocation.asEditable,
        importInputLocation.asEditable,
        modality,
        testSetTags.map(value => value)
      )
    def testSetName: Name
    def description: Optional[Description]
    def roleArn: RoleArn
    def storageLocation
        : zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly
    def importInputLocation
        : zio.aws.lexmodelsv2.model.TestSetImportInputLocation.ReadOnly
    def modality: zio.aws.lexmodelsv2.model.TestSetModality
    def testSetTags: Optional[Map[TagKey, TagValue]]
    def getTestSetName: ZIO[Any, Nothing, Name] = ZIO.succeed(testSetName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStorageLocation: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly
    ] = ZIO.succeed(storageLocation)
    def getImportInputLocation: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.TestSetImportInputLocation.ReadOnly
    ] = ZIO.succeed(importInputLocation)
    def getModality
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.TestSetModality] =
      ZIO.succeed(modality)
    def getTestSetTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("testSetTags", testSetTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetImportResourceSpecification
  ) extends zio.aws.lexmodelsv2.model.TestSetImportResourceSpecification.ReadOnly {
    override val testSetName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.testSetName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val roleArn: RoleArn =
      zio.aws.lexmodelsv2.model.primitives.RoleArn(impl.roleArn())
    override val storageLocation
        : zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly =
      zio.aws.lexmodelsv2.model.TestSetStorageLocation
        .wrap(impl.storageLocation())
    override val importInputLocation
        : zio.aws.lexmodelsv2.model.TestSetImportInputLocation.ReadOnly =
      zio.aws.lexmodelsv2.model.TestSetImportInputLocation
        .wrap(impl.importInputLocation())
    override val modality: zio.aws.lexmodelsv2.model.TestSetModality =
      zio.aws.lexmodelsv2.model.TestSetModality.wrap(impl.modality())
    override val testSetTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSetTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lexmodelsv2.model.primitives.TagKey(
                key
              ) -> zio.aws.lexmodelsv2.model.primitives.TagValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetImportResourceSpecification
  ): zio.aws.lexmodelsv2.model.TestSetImportResourceSpecification.ReadOnly =
    new Wrapper(impl)
}
