package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestSetDiscrepancyReportResourceTarget(
    botAliasTarget: Optional[
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget = {
    import TestSetDiscrepancyReportResourceTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget
      .builder()
      .optionallyWith(botAliasTarget.map(value => value.buildAwsValue()))(
        _.botAliasTarget
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget
      .wrap(buildAwsValue())
}
object TestSetDiscrepancyReportResourceTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget =
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget(
        botAliasTarget.map(value => value.asEditable)
      )
    def botAliasTarget: Optional[
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget.ReadOnly
    ]
    def getBotAliasTarget: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget.ReadOnly
    ] = AwsError.unwrapOptionField("botAliasTarget", botAliasTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget
  ) extends zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget.ReadOnly {
    override val botAliasTarget: Optional[
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasTarget())
      .map(value =>
        zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportBotAliasTarget
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget
  ): zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget.ReadOnly =
    new Wrapper(impl)
}
