package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SlotCaptureSetting(
    captureResponse: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent,
    captureNextStep: Optional[zio.aws.lexmodelsv2.model.DialogState] =
      Optional.Absent,
    captureConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification
    ] = Optional.Absent,
    failureResponse: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent,
    failureNextStep: Optional[zio.aws.lexmodelsv2.model.DialogState] =
      Optional.Absent,
    failureConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification
    ] = Optional.Absent,
    codeHook: Optional[
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting
    ] = Optional.Absent,
    elicitationCodeHook: Optional[
      zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotCaptureSetting = {
    import SlotCaptureSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotCaptureSetting
      .builder()
      .optionallyWith(captureResponse.map(value => value.buildAwsValue()))(
        _.captureResponse
      )
      .optionallyWith(captureNextStep.map(value => value.buildAwsValue()))(
        _.captureNextStep
      )
      .optionallyWith(captureConditional.map(value => value.buildAwsValue()))(
        _.captureConditional
      )
      .optionallyWith(failureResponse.map(value => value.buildAwsValue()))(
        _.failureResponse
      )
      .optionallyWith(failureNextStep.map(value => value.buildAwsValue()))(
        _.failureNextStep
      )
      .optionallyWith(failureConditional.map(value => value.buildAwsValue()))(
        _.failureConditional
      )
      .optionallyWith(codeHook.map(value => value.buildAwsValue()))(_.codeHook)
      .optionallyWith(elicitationCodeHook.map(value => value.buildAwsValue()))(
        _.elicitationCodeHook
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotCaptureSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotCaptureSetting.wrap(buildAwsValue())
}
object SlotCaptureSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotCaptureSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotCaptureSetting =
      zio.aws.lexmodelsv2.model.SlotCaptureSetting(
        captureResponse.map(value => value.asEditable),
        captureNextStep.map(value => value.asEditable),
        captureConditional.map(value => value.asEditable),
        failureResponse.map(value => value.asEditable),
        failureNextStep.map(value => value.asEditable),
        failureConditional.map(value => value.asEditable),
        codeHook.map(value => value.asEditable),
        elicitationCodeHook.map(value => value.asEditable)
      )
    def captureResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def captureNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly]
    def captureConditional
        : Optional[zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly]
    def failureResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def failureNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly]
    def failureConditional
        : Optional[zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly]
    def codeHook: Optional[
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.ReadOnly
    ]
    def elicitationCodeHook: Optional[
      zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.ReadOnly
    ]
    def getCaptureResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("captureResponse", captureResponse)
    def getCaptureNextStep
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      AwsError.unwrapOptionField("captureNextStep", captureNextStep)
    def getCaptureConditional: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("captureConditional", captureConditional)
    def getFailureResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("failureResponse", failureResponse)
    def getFailureNextStep
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      AwsError.unwrapOptionField("failureNextStep", failureNextStep)
    def getFailureConditional: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("failureConditional", failureConditional)
    def getCodeHook: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.ReadOnly
    ] = AwsError.unwrapOptionField("codeHook", codeHook)
    def getElicitationCodeHook: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.ReadOnly
    ] = AwsError.unwrapOptionField("elicitationCodeHook", elicitationCodeHook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotCaptureSetting
  ) extends zio.aws.lexmodelsv2.model.SlotCaptureSetting.ReadOnly {
    override val captureResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.captureResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
    override val captureNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.captureNextStep())
        .map(value => zio.aws.lexmodelsv2.model.DialogState.wrap(value))
    override val captureConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.captureConditional())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConditionalSpecification.wrap(value)
      )
    override val failureResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
    override val failureNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureNextStep())
        .map(value => zio.aws.lexmodelsv2.model.DialogState.wrap(value))
    override val failureConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failureConditional())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConditionalSpecification.wrap(value)
      )
    override val codeHook: Optional[
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.codeHook())
      .map(value =>
        zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.wrap(value)
      )
    override val elicitationCodeHook: Optional[
      zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elicitationCodeHook())
      .map(value =>
        zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotCaptureSetting
  ): zio.aws.lexmodelsv2.model.SlotCaptureSetting.ReadOnly = new Wrapper(impl)
}
