package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{NextToken, MaxResults, Id}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTestSetRecordsRequest(
    testSetId: Id,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest = {
    import ListTestSetRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest
      .builder()
      .testSetId(Id.unwrap(testSetId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListTestSetRecordsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListTestSetRecordsRequest.wrap(buildAwsValue())
}
object ListTestSetRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListTestSetRecordsRequest =
      zio.aws.lexmodelsv2.model.ListTestSetRecordsRequest(
        testSetId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def testSetId: Id
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getTestSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(testSetId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest
  ) extends zio.aws.lexmodelsv2.model.ListTestSetRecordsRequest.ReadOnly {
    override val testSetId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.testSetId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest
  ): zio.aws.lexmodelsv2.model.ListTestSetRecordsRequest.ReadOnly = new Wrapper(
    impl
  )
}
