package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  MaxResults,
  Timestamp,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSessionMetricsRequest(
    botId: Id,
    startDateTime: Timestamp,
    endDateTime: Timestamp,
    metrics: Iterable[zio.aws.lexmodelsv2.model.AnalyticsSessionMetric],
    binBy: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification]
    ] = Optional.Absent,
    groupBy: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsSessionGroupBySpecification]
    ] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsSessionFilter]
    ] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest = {
    import ListSessionMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .startDateTime(Timestamp.unwrap(startDateTime): Instant)
      .endDateTime(Timestamp.unwrap(endDateTime): Instant)
      .metrics(metrics.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        binBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.binBy)
      .optionallyWith(
        groupBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupBy)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListSessionMetricsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListSessionMetricsRequest.wrap(buildAwsValue())
}
object ListSessionMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListSessionMetricsRequest =
      zio.aws.lexmodelsv2.model.ListSessionMetricsRequest(
        botId,
        startDateTime,
        endDateTime,
        metrics.map { item =>
          item.asEditable
        },
        binBy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupBy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def botId: Id
    def startDateTime: Timestamp
    def endDateTime: Timestamp
    def metrics: List[zio.aws.lexmodelsv2.model.AnalyticsSessionMetric.ReadOnly]
    def binBy: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification.ReadOnly]
    ]
    def groupBy: Optional[List[
      zio.aws.lexmodelsv2.model.AnalyticsSessionGroupBySpecification.ReadOnly
    ]]
    def filters: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsSessionFilter.ReadOnly]
    ]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getStartDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(startDateTime)
    def getEndDateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDateTime)
    def getMetrics: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.AnalyticsSessionMetric.ReadOnly
    ]] = ZIO.succeed(metrics)
    def getBinBy: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("binBy", binBy)
    def getGroupBy: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsSessionGroupBySpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("groupBy", groupBy)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsSessionFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest
  ) extends zio.aws.lexmodelsv2.model.ListSessionMetricsRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val startDateTime: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.startDateTime())
    override val endDateTime: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.endDateTime())
    override val metrics
        : List[zio.aws.lexmodelsv2.model.AnalyticsSessionMetric.ReadOnly] = impl
      .metrics()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.AnalyticsSessionMetric.wrap(item)
      }
      .toList
    override val binBy: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.binBy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsBinBySpecification.wrap(item)
        }.toList
      )
    override val groupBy: Optional[List[
      zio.aws.lexmodelsv2.model.AnalyticsSessionGroupBySpecification.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.groupBy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsSessionGroupBySpecification
            .wrap(item)
        }.toList
      )
    override val filters: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsSessionFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsSessionFilter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest
  ): zio.aws.lexmodelsv2.model.ListSessionMetricsRequest.ReadOnly = new Wrapper(
    impl
  )
}
