package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Name
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IntentClassificationTestResultItem(
    intentName: Name,
    multiTurnConversation: Boolean,
    resultCounts: zio.aws.lexmodelsv2.model.IntentClassificationTestResultItemCounts
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResultItem = {
    import IntentClassificationTestResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResultItem
      .builder()
      .intentName(Name.unwrap(intentName): java.lang.String)
      .multiTurnConversation(multiTurnConversation: java.lang.Boolean)
      .resultCounts(resultCounts.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.IntentClassificationTestResultItem.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentClassificationTestResultItem
      .wrap(buildAwsValue())
}
object IntentClassificationTestResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.IntentClassificationTestResultItem =
      zio.aws.lexmodelsv2.model.IntentClassificationTestResultItem(
        intentName,
        multiTurnConversation,
        resultCounts.asEditable
      )
    def intentName: Name
    def multiTurnConversation: Boolean
    def resultCounts
        : zio.aws.lexmodelsv2.model.IntentClassificationTestResultItemCounts.ReadOnly
    def getIntentName: ZIO[Any, Nothing, Name] = ZIO.succeed(intentName)
    def getMultiTurnConversation: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(multiTurnConversation)
    def getResultCounts: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.IntentClassificationTestResultItemCounts.ReadOnly
    ] = ZIO.succeed(resultCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResultItem
  ) extends zio.aws.lexmodelsv2.model.IntentClassificationTestResultItem.ReadOnly {
    override val intentName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.intentName())
    override val multiTurnConversation: Boolean =
      impl.multiTurnConversation(): Boolean
    override val resultCounts
        : zio.aws.lexmodelsv2.model.IntentClassificationTestResultItemCounts.ReadOnly =
      zio.aws.lexmodelsv2.model.IntentClassificationTestResultItemCounts
        .wrap(impl.resultCounts())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResultItem
  ): zio.aws.lexmodelsv2.model.IntentClassificationTestResultItem.ReadOnly =
    new Wrapper(impl)
}
