package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait DialogActionType {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType
}
object DialogActionType {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType
  ): zio.aws.lexmodelsv2.model.DialogActionType = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.ELICIT_INTENT =>
      val r = ElicitIntent
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.START_INTENT =>
      val r = StartIntent
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.ELICIT_SLOT =>
      val r = ElicitSlot
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.EVALUATE_CONDITIONAL =>
      val r = EvaluateConditional
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.INVOKE_DIALOG_CODE_HOOK =>
      val r = InvokeDialogCodeHook
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.CONFIRM_INTENT =>
      val r = ConfirmIntent
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.FULFILL_INTENT =>
      val r = FulfillIntent
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.CLOSE_INTENT =>
      val r = CloseIntent
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.END_CONVERSATION =>
      val r = EndConversation
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType =
      software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object ElicitIntent extends zio.aws.lexmodelsv2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType =
      software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.ELICIT_INTENT
  }
  case object StartIntent extends zio.aws.lexmodelsv2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType =
      software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.START_INTENT
  }
  case object ElicitSlot extends zio.aws.lexmodelsv2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType =
      software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.ELICIT_SLOT
  }
  case object EvaluateConditional
      extends zio.aws.lexmodelsv2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType =
      software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.EVALUATE_CONDITIONAL
  }
  case object InvokeDialogCodeHook
      extends zio.aws.lexmodelsv2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType =
      software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.INVOKE_DIALOG_CODE_HOOK
  }
  case object ConfirmIntent extends zio.aws.lexmodelsv2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType =
      software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.CONFIRM_INTENT
  }
  case object FulfillIntent extends zio.aws.lexmodelsv2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType =
      software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.FULFILL_INTENT
  }
  case object CloseIntent extends zio.aws.lexmodelsv2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType =
      software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.CLOSE_INTENT
  }
  case object EndConversation
      extends zio.aws.lexmodelsv2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType =
      software.amazon.awssdk.services.lexmodelsv2.model.DialogActionType.END_CONVERSATION
  }
}
