package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestSetTurnResult(
    agent: Optional[zio.aws.lexmodelsv2.model.AgentTurnResult] =
      Optional.Absent,
    user: Optional[zio.aws.lexmodelsv2.model.UserTurnResult] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnResult = {
    import TestSetTurnResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnResult
      .builder()
      .optionallyWith(agent.map(value => value.buildAwsValue()))(_.agent)
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TestSetTurnResult.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetTurnResult.wrap(buildAwsValue())
}
object TestSetTurnResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestSetTurnResult =
      zio.aws.lexmodelsv2.model.TestSetTurnResult(
        agent.map(value => value.asEditable),
        user.map(value => value.asEditable)
      )
    def agent: Optional[zio.aws.lexmodelsv2.model.AgentTurnResult.ReadOnly]
    def user: Optional[zio.aws.lexmodelsv2.model.UserTurnResult.ReadOnly]
    def getAgent: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AgentTurnResult.ReadOnly
    ] = AwsError.unwrapOptionField("agent", agent)
    def getUser: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.UserTurnResult.ReadOnly
    ] = AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnResult
  ) extends zio.aws.lexmodelsv2.model.TestSetTurnResult.ReadOnly {
    override val agent
        : Optional[zio.aws.lexmodelsv2.model.AgentTurnResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.agent())
        .map(value => zio.aws.lexmodelsv2.model.AgentTurnResult.wrap(value))
    override val user
        : Optional[zio.aws.lexmodelsv2.model.UserTurnResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.user())
        .map(value => zio.aws.lexmodelsv2.model.UserTurnResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnResult
  ): zio.aws.lexmodelsv2.model.TestSetTurnResult.ReadOnly = new Wrapper(impl)
}
