package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{NextToken, BotVersion, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBotLocalesResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    botLocaleSummaries: Optional[
      Iterable[zio.aws.lexmodelsv2.model.BotLocaleSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse = {
    import ListBotLocalesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        botLocaleSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botLocaleSummaries)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListBotLocalesResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBotLocalesResponse.wrap(buildAwsValue())
}
object ListBotLocalesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBotLocalesResponse =
      zio.aws.lexmodelsv2.model.ListBotLocalesResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        nextToken.map(value => value),
        botLocaleSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def botId: Optional[Id]
    def botVersion: Optional[BotVersion]
    def nextToken: Optional[NextToken]
    def botLocaleSummaries
        : Optional[List[zio.aws.lexmodelsv2.model.BotLocaleSummary.ReadOnly]]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBotLocaleSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotLocaleSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("botLocaleSummaries", botLocaleSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse
  ) extends zio.aws.lexmodelsv2.model.ListBotLocalesResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val botLocaleSummaries
        : Optional[List[zio.aws.lexmodelsv2.model.BotLocaleSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botLocaleSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.BotLocaleSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse
  ): zio.aws.lexmodelsv2.model.ListBotLocalesResponse.ReadOnly = new Wrapper(
    impl
  )
}
