package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Name
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InputContext(name: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.InputContext = {
    import InputContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.InputContext
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.InputContext.ReadOnly =
    zio.aws.lexmodelsv2.model.InputContext.wrap(buildAwsValue())
}
object InputContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.InputContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.InputContext =
      zio.aws.lexmodelsv2.model.InputContext(name)
    def name: Name
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.InputContext
  ) extends zio.aws.lexmodelsv2.model.InputContext.ReadOnly {
    override val name: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.InputContext
  ): zio.aws.lexmodelsv2.model.InputContext.ReadOnly = new Wrapper(impl)
}
