package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait ImportExportFileFormat {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat
}
object ImportExportFileFormat {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat
  ): zio.aws.lexmodelsv2.model.ImportExportFileFormat = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat.LEX_JSON =>
      val r = LexJson
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat.TSV =>
      val r = TSV
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat.CSV =>
      val r = CSV
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.ImportExportFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object LexJson extends zio.aws.lexmodelsv2.model.ImportExportFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat.LEX_JSON
  }
  case object TSV extends zio.aws.lexmodelsv2.model.ImportExportFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat.TSV
  }
  case object CSV extends zio.aws.lexmodelsv2.model.ImportExportFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat.CSV
  }
}
