package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait SearchOrder {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.SearchOrder
}
object SearchOrder {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.SearchOrder
  ): zio.aws.lexmodelsv2.model.SearchOrder = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.SearchOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SearchOrder.ASCENDING =>
      val r = Ascending
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SearchOrder.DESCENDING =>
      val r = Descending
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.SearchOrder {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SearchOrder =
      software.amazon.awssdk.services.lexmodelsv2.model.SearchOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object Ascending extends zio.aws.lexmodelsv2.model.SearchOrder {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SearchOrder =
      software.amazon.awssdk.services.lexmodelsv2.model.SearchOrder.ASCENDING
  }
  case object Descending extends zio.aws.lexmodelsv2.model.SearchOrder {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SearchOrder =
      software.amazon.awssdk.services.lexmodelsv2.model.SearchOrder.DESCENDING
  }
}
