package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PromptAttemptSpecification(
    allowInterrupt: Optional[BoxedBoolean] = Optional.Absent,
    allowedInputTypes: zio.aws.lexmodelsv2.model.AllowedInputTypes,
    audioAndDTMFInputSpecification: Optional[
      zio.aws.lexmodelsv2.model.AudioAndDTMFInputSpecification
    ] = Optional.Absent,
    textInputSpecification: Optional[
      zio.aws.lexmodelsv2.model.TextInputSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.PromptAttemptSpecification = {
    import PromptAttemptSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.PromptAttemptSpecification
      .builder()
      .optionallyWith(allowInterrupt.map(value => value: java.lang.Boolean))(
        _.allowInterrupt
      )
      .allowedInputTypes(allowedInputTypes.buildAwsValue())
      .optionallyWith(
        audioAndDTMFInputSpecification.map(value => value.buildAwsValue())
      )(_.audioAndDTMFInputSpecification)
      .optionallyWith(
        textInputSpecification.map(value => value.buildAwsValue())
      )(_.textInputSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.PromptAttemptSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.PromptAttemptSpecification.wrap(buildAwsValue())
}
object PromptAttemptSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.PromptAttemptSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.PromptAttemptSpecification =
      zio.aws.lexmodelsv2.model.PromptAttemptSpecification(
        allowInterrupt.map(value => value),
        allowedInputTypes.asEditable,
        audioAndDTMFInputSpecification.map(value => value.asEditable),
        textInputSpecification.map(value => value.asEditable)
      )
    def allowInterrupt: Optional[BoxedBoolean]
    def allowedInputTypes: zio.aws.lexmodelsv2.model.AllowedInputTypes.ReadOnly
    def audioAndDTMFInputSpecification: Optional[
      zio.aws.lexmodelsv2.model.AudioAndDTMFInputSpecification.ReadOnly
    ]
    def textInputSpecification
        : Optional[zio.aws.lexmodelsv2.model.TextInputSpecification.ReadOnly]
    def getAllowInterrupt: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("allowInterrupt", allowInterrupt)
    def getAllowedInputTypes: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AllowedInputTypes.ReadOnly
    ] = ZIO.succeed(allowedInputTypes)
    def getAudioAndDTMFInputSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AudioAndDTMFInputSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "audioAndDTMFInputSpecification",
      audioAndDTMFInputSpecification
    )
    def getTextInputSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TextInputSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "textInputSpecification",
      textInputSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PromptAttemptSpecification
  ) extends zio.aws.lexmodelsv2.model.PromptAttemptSpecification.ReadOnly {
    override val allowInterrupt: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowInterrupt())
      .map(value => value: BoxedBoolean)
    override val allowedInputTypes
        : zio.aws.lexmodelsv2.model.AllowedInputTypes.ReadOnly =
      zio.aws.lexmodelsv2.model.AllowedInputTypes.wrap(impl.allowedInputTypes())
    override val audioAndDTMFInputSpecification: Optional[
      zio.aws.lexmodelsv2.model.AudioAndDTMFInputSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.audioAndDTMFInputSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.AudioAndDTMFInputSpecification.wrap(value)
      )
    override val textInputSpecification
        : Optional[zio.aws.lexmodelsv2.model.TextInputSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textInputSpecification())
        .map(value =>
          zio.aws.lexmodelsv2.model.TextInputSpecification.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PromptAttemptSpecification
  ): zio.aws.lexmodelsv2.model.PromptAttemptSpecification.ReadOnly =
    new Wrapper(impl)
}
