package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait ObfuscationSettingType {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.ObfuscationSettingType
}
object ObfuscationSettingType {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.ObfuscationSettingType
  ): zio.aws.lexmodelsv2.model.ObfuscationSettingType = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.ObfuscationSettingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ObfuscationSettingType.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ObfuscationSettingType.DEFAULT_OBFUSCATION =>
      val r = DefaultObfuscation
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.ObfuscationSettingType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ObfuscationSettingType =
      software.amazon.awssdk.services.lexmodelsv2.model.ObfuscationSettingType.UNKNOWN_TO_SDK_VERSION
  }
  case object None extends zio.aws.lexmodelsv2.model.ObfuscationSettingType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ObfuscationSettingType =
      software.amazon.awssdk.services.lexmodelsv2.model.ObfuscationSettingType.NONE
  }
  case object DefaultObfuscation
      extends zio.aws.lexmodelsv2.model.ObfuscationSettingType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ObfuscationSettingType =
      software.amazon.awssdk.services.lexmodelsv2.model.ObfuscationSettingType.DEFAULT_OBFUSCATION
  }
}
