package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBuiltInIntentsResponse(
    builtInIntentSummaries: Optional[
      Iterable[zio.aws.lexmodelsv2.model.BuiltInIntentSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse = {
    import ListBuiltInIntentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse
      .builder()
      .optionallyWith(
        builtInIntentSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.builtInIntentSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.wrap(buildAwsValue())
}
object ListBuiltInIntentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse =
      zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse(
        builtInIntentSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        localeId.map(value => value)
      )
    def builtInIntentSummaries: Optional[
      List[zio.aws.lexmodelsv2.model.BuiltInIntentSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def localeId: Optional[LocaleId]
    def getBuiltInIntentSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BuiltInIntentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "builtInIntentSummaries",
      builtInIntentSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse
  ) extends zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.ReadOnly {
    override val builtInIntentSummaries: Optional[
      List[zio.aws.lexmodelsv2.model.BuiltInIntentSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.builtInIntentSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.BuiltInIntentSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse
  ): zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.ReadOnly =
    new Wrapper(impl)
}
