package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  RoleArn,
  SessionTTL,
  Description,
  Name,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateBotRequest(
    botId: Id,
    botName: Name,
    description: Optional[Description] = Optional.Absent,
    roleArn: RoleArn,
    dataPrivacy: zio.aws.lexmodelsv2.model.DataPrivacy,
    idleSessionTTLInSeconds: SessionTTL,
    botType: Optional[zio.aws.lexmodelsv2.model.BotType] = Optional.Absent,
    botMembers: Optional[Iterable[zio.aws.lexmodelsv2.model.BotMember]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest = {
    import UpdateBotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botName(Name.unwrap(botName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .dataPrivacy(dataPrivacy.buildAwsValue())
      .idleSessionTTLInSeconds(
        SessionTTL.unwrap(idleSessionTTLInSeconds): Integer
      )
      .optionallyWith(botType.map(value => value.unwrap))(_.botType)
      .optionallyWith(
        botMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botMembers)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateBotRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateBotRequest.wrap(buildAwsValue())
}
object UpdateBotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateBotRequest =
      zio.aws.lexmodelsv2.model.UpdateBotRequest(
        botId,
        botName,
        description.map(value => value),
        roleArn,
        dataPrivacy.asEditable,
        idleSessionTTLInSeconds,
        botType.map(value => value),
        botMembers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def botId: Id
    def botName: Name
    def description: Optional[Description]
    def roleArn: RoleArn
    def dataPrivacy: zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly
    def idleSessionTTLInSeconds: SessionTTL
    def botType: Optional[zio.aws.lexmodelsv2.model.BotType]
    def botMembers: Optional[List[zio.aws.lexmodelsv2.model.BotMember.ReadOnly]]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotName: ZIO[Any, Nothing, Name] = ZIO.succeed(botName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getDataPrivacy
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly] =
      ZIO.succeed(dataPrivacy)
    def getIdleSessionTTLInSeconds: ZIO[Any, Nothing, SessionTTL] =
      ZIO.succeed(idleSessionTTLInSeconds)
    def getBotType: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotType] =
      AwsError.unwrapOptionField("botType", botType)
    def getBotMembers: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotMember.ReadOnly
    ]] = AwsError.unwrapOptionField("botMembers", botMembers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest
  ) extends zio.aws.lexmodelsv2.model.UpdateBotRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.botName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val roleArn: RoleArn =
      zio.aws.lexmodelsv2.model.primitives.RoleArn(impl.roleArn())
    override val dataPrivacy: zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly =
      zio.aws.lexmodelsv2.model.DataPrivacy.wrap(impl.dataPrivacy())
    override val idleSessionTTLInSeconds: SessionTTL =
      zio.aws.lexmodelsv2.model.primitives
        .SessionTTL(impl.idleSessionTTLInSeconds())
    override val botType: Optional[zio.aws.lexmodelsv2.model.BotType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botType())
        .map(value => zio.aws.lexmodelsv2.model.BotType.wrap(value))
    override val botMembers
        : Optional[List[zio.aws.lexmodelsv2.model.BotMember.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botMembers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.BotMember.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest
  ): zio.aws.lexmodelsv2.model.UpdateBotRequest.ReadOnly = new Wrapper(impl)
}
