package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  NextToken,
  BotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListExportsResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    exportSummaries: Optional[
      Iterable[zio.aws.lexmodelsv2.model.ExportSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse = {
    import ListExportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        exportSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exportSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListExportsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListExportsResponse.wrap(buildAwsValue())
}
object ListExportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListExportsResponse =
      zio.aws.lexmodelsv2.model.ListExportsResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        exportSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        localeId.map(value => value)
      )
    def botId: Optional[Id]
    def botVersion: Optional[BotVersion]
    def exportSummaries
        : Optional[List[zio.aws.lexmodelsv2.model.ExportSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def localeId: Optional[LocaleId]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getExportSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.ExportSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("exportSummaries", exportSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse
  ) extends zio.aws.lexmodelsv2.model.ListExportsResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val exportSummaries
        : Optional[List[zio.aws.lexmodelsv2.model.ExportSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.ExportSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse
  ): zio.aws.lexmodelsv2.model.ListExportsResponse.ReadOnly = new Wrapper(impl)
}
