package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{Weight, Phrase, ItemId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CustomVocabularyItem(
    itemId: ItemId,
    phrase: Phrase,
    weight: Optional[Weight] = Optional.Absent,
    displayAs: Optional[Phrase] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem = {
    import CustomVocabularyItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem
      .builder()
      .itemId(ItemId.unwrap(itemId): java.lang.String)
      .phrase(Phrase.unwrap(phrase): java.lang.String)
      .optionallyWith(weight.map(value => Weight.unwrap(value): Integer))(
        _.weight
      )
      .optionallyWith(
        displayAs.map(value => Phrase.unwrap(value): java.lang.String)
      )(_.displayAs)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CustomVocabularyItem.ReadOnly =
    zio.aws.lexmodelsv2.model.CustomVocabularyItem.wrap(buildAwsValue())
}
object CustomVocabularyItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CustomVocabularyItem =
      zio.aws.lexmodelsv2.model.CustomVocabularyItem(
        itemId,
        phrase,
        weight.map(value => value),
        displayAs.map(value => value)
      )
    def itemId: ItemId
    def phrase: Phrase
    def weight: Optional[Weight]
    def displayAs: Optional[Phrase]
    def getItemId: ZIO[Any, Nothing, ItemId] = ZIO.succeed(itemId)
    def getPhrase: ZIO[Any, Nothing, Phrase] = ZIO.succeed(phrase)
    def getWeight: ZIO[Any, AwsError, Weight] =
      AwsError.unwrapOptionField("weight", weight)
    def getDisplayAs: ZIO[Any, AwsError, Phrase] =
      AwsError.unwrapOptionField("displayAs", displayAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem
  ) extends zio.aws.lexmodelsv2.model.CustomVocabularyItem.ReadOnly {
    override val itemId: ItemId =
      zio.aws.lexmodelsv2.model.primitives.ItemId(impl.itemId())
    override val phrase: Phrase =
      zio.aws.lexmodelsv2.model.primitives.Phrase(impl.phrase())
    override val weight: Optional[Weight] = zio.aws.core.internal
      .optionalFromNullable(impl.weight())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Weight(value))
    override val displayAs: Optional[Phrase] = zio.aws.core.internal
      .optionalFromNullable(impl.displayAs())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Phrase(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem
  ): zio.aws.lexmodelsv2.model.CustomVocabularyItem.ReadOnly = new Wrapper(impl)
}
