package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  BotAliasId,
  BotAliasName,
  BotVersion,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BotMember(
    botMemberId: Id,
    botMemberName: Name,
    botMemberAliasId: BotAliasId,
    botMemberAliasName: BotAliasName,
    botMemberVersion: BotVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotMember = {
    import BotMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotMember
      .builder()
      .botMemberId(Id.unwrap(botMemberId): java.lang.String)
      .botMemberName(Name.unwrap(botMemberName): java.lang.String)
      .botMemberAliasId(BotAliasId.unwrap(botMemberAliasId): java.lang.String)
      .botMemberAliasName(
        BotAliasName.unwrap(botMemberAliasName): java.lang.String
      )
      .botMemberVersion(BotVersion.unwrap(botMemberVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotMember.ReadOnly =
    zio.aws.lexmodelsv2.model.BotMember.wrap(buildAwsValue())
}
object BotMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotMember =
      zio.aws.lexmodelsv2.model.BotMember(
        botMemberId,
        botMemberName,
        botMemberAliasId,
        botMemberAliasName,
        botMemberVersion
      )
    def botMemberId: Id
    def botMemberName: Name
    def botMemberAliasId: BotAliasId
    def botMemberAliasName: BotAliasName
    def botMemberVersion: BotVersion
    def getBotMemberId: ZIO[Any, Nothing, Id] = ZIO.succeed(botMemberId)
    def getBotMemberName: ZIO[Any, Nothing, Name] = ZIO.succeed(botMemberName)
    def getBotMemberAliasId: ZIO[Any, Nothing, BotAliasId] =
      ZIO.succeed(botMemberAliasId)
    def getBotMemberAliasName: ZIO[Any, Nothing, BotAliasName] =
      ZIO.succeed(botMemberAliasName)
    def getBotMemberVersion: ZIO[Any, Nothing, BotVersion] =
      ZIO.succeed(botMemberVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotMember
  ) extends zio.aws.lexmodelsv2.model.BotMember.ReadOnly {
    override val botMemberId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botMemberId())
    override val botMemberName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.botMemberName())
    override val botMemberAliasId: BotAliasId =
      zio.aws.lexmodelsv2.model.primitives.BotAliasId(impl.botMemberAliasId())
    override val botMemberAliasName: BotAliasName =
      zio.aws.lexmodelsv2.model.primitives
        .BotAliasName(impl.botMemberAliasName())
    override val botMemberVersion: BotVersion =
      zio.aws.lexmodelsv2.model.primitives.BotVersion(impl.botMemberVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotMember
  ): zio.aws.lexmodelsv2.model.BotMember.ReadOnly = new Wrapper(impl)
}
