package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, DraftBotVersion, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateBotRecommendationRequest(
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId,
    botRecommendationId: Id,
    encryptionSetting: zio.aws.lexmodelsv2.model.EncryptionSetting
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationRequest = {
    import UpdateBotRecommendationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .botRecommendationId(Id.unwrap(botRecommendationId): java.lang.String)
      .encryptionSetting(encryptionSetting.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.UpdateBotRecommendationRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateBotRecommendationRequest
      .wrap(buildAwsValue())
}
object UpdateBotRecommendationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateBotRecommendationRequest =
      zio.aws.lexmodelsv2.model.UpdateBotRecommendationRequest(
        botId,
        botVersion,
        localeId,
        botRecommendationId,
        encryptionSetting.asEditable
      )
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def botRecommendationId: Id
    def encryptionSetting: zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getBotRecommendationId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(botRecommendationId)
    def getEncryptionSetting: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly
    ] = ZIO.succeed(encryptionSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationRequest
  ) extends zio.aws.lexmodelsv2.model.UpdateBotRecommendationRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val botRecommendationId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botRecommendationId())
    override val encryptionSetting
        : zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly =
      zio.aws.lexmodelsv2.model.EncryptionSetting.wrap(impl.encryptionSetting())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationRequest
  ): zio.aws.lexmodelsv2.model.UpdateBotRecommendationRequest.ReadOnly =
    new Wrapper(impl)
}
