package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.TimeInMilliSeconds
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TextInputSpecification(startTimeoutMs: TimeInMilliSeconds) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TextInputSpecification = {
    import TextInputSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TextInputSpecification
      .builder()
      .startTimeoutMs(TimeInMilliSeconds.unwrap(startTimeoutMs): Integer)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TextInputSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.TextInputSpecification.wrap(buildAwsValue())
}
object TextInputSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TextInputSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TextInputSpecification =
      zio.aws.lexmodelsv2.model.TextInputSpecification(startTimeoutMs)
    def startTimeoutMs: TimeInMilliSeconds
    def getStartTimeoutMs: ZIO[Any, Nothing, TimeInMilliSeconds] =
      ZIO.succeed(startTimeoutMs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TextInputSpecification
  ) extends zio.aws.lexmodelsv2.model.TextInputSpecification.ReadOnly {
    override val startTimeoutMs: TimeInMilliSeconds =
      zio.aws.lexmodelsv2.model.primitives
        .TimeInMilliSeconds(impl.startTimeoutMs())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TextInputSpecification
  ): zio.aws.lexmodelsv2.model.TextInputSpecification.ReadOnly = new Wrapper(
    impl
  )
}
