package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.SlotDefaultValueString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SlotDefaultValue(defaultValue: SlotDefaultValueString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotDefaultValue = {
    import SlotDefaultValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotDefaultValue
      .builder()
      .defaultValue(
        SlotDefaultValueString.unwrap(defaultValue): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotDefaultValue.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotDefaultValue.wrap(buildAwsValue())
}
object SlotDefaultValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotDefaultValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotDefaultValue =
      zio.aws.lexmodelsv2.model.SlotDefaultValue(defaultValue)
    def defaultValue: SlotDefaultValueString
    def getDefaultValue: ZIO[Any, Nothing, SlotDefaultValueString] =
      ZIO.succeed(defaultValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotDefaultValue
  ) extends zio.aws.lexmodelsv2.model.SlotDefaultValue.ReadOnly {
    override val defaultValue: SlotDefaultValueString =
      zio.aws.lexmodelsv2.model.primitives
        .SlotDefaultValueString(impl.defaultValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotDefaultValue
  ): zio.aws.lexmodelsv2.model.SlotDefaultValue.ReadOnly = new Wrapper(impl)
}
