package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, DraftBotVersion, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopBotRecommendationResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[DraftBotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    botRecommendationStatus: Optional[
      zio.aws.lexmodelsv2.model.BotRecommendationStatus
    ] = Optional.Absent,
    botRecommendationId: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationResponse = {
    import StopBotRecommendationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(botRecommendationStatus.map(value => value.unwrap))(
        _.botRecommendationStatus
      )
      .optionallyWith(
        botRecommendationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.botRecommendationId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.StopBotRecommendationResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.StopBotRecommendationResponse
      .wrap(buildAwsValue())
}
object StopBotRecommendationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.StopBotRecommendationResponse =
      zio.aws.lexmodelsv2.model.StopBotRecommendationResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        botRecommendationStatus.map(value => value),
        botRecommendationId.map(value => value)
      )
    def botId: Optional[Id]
    def botVersion: Optional[DraftBotVersion]
    def localeId: Optional[LocaleId]
    def botRecommendationStatus
        : Optional[zio.aws.lexmodelsv2.model.BotRecommendationStatus]
    def botRecommendationId: Optional[Id]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getBotRecommendationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotRecommendationStatus
    ] = AwsError.unwrapOptionField(
      "botRecommendationStatus",
      botRecommendationStatus
    )
    def getBotRecommendationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botRecommendationId", botRecommendationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationResponse
  ) extends zio.aws.lexmodelsv2.model.StopBotRecommendationResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[DraftBotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val botRecommendationStatus
        : Optional[zio.aws.lexmodelsv2.model.BotRecommendationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botRecommendationStatus())
        .map(value =>
          zio.aws.lexmodelsv2.model.BotRecommendationStatus.wrap(value)
        )
    override val botRecommendationId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botRecommendationId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationResponse
  ): zio.aws.lexmodelsv2.model.StopBotRecommendationResponse.ReadOnly =
    new Wrapper(impl)
}
