package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  BotAliasId,
  Timestamp,
  Description,
  BotVersion,
  Name,
  Id
}
import scala.jdk.CollectionConverters._
final case class DescribeBotAliasResponse(
    botAliasId: Optional[BotAliasId] = Optional.Absent,
    botAliasName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    botAliasLocaleSettings: Optional[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings]
    ] = Optional.Absent,
    conversationLogSettings: Optional[
      zio.aws.lexmodelsv2.model.ConversationLogSettings
    ] = Optional.Absent,
    sentimentAnalysisSettings: Optional[
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings
    ] = Optional.Absent,
    botAliasHistoryEvents: Optional[
      Iterable[zio.aws.lexmodelsv2.model.BotAliasHistoryEvent]
    ] = Optional.Absent,
    botAliasStatus: Optional[zio.aws.lexmodelsv2.model.BotAliasStatus] =
      Optional.Absent,
    botId: Optional[Id] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent,
    parentBotNetworks: Optional[
      Iterable[zio.aws.lexmodelsv2.model.ParentBotNetwork]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse = {
    import DescribeBotAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse
      .builder()
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(
        botAliasName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botAliasName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        botAliasLocaleSettings.map(value =>
          value
            .map({ case (key, value) =>
              (LocaleId.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.botAliasLocaleSettings)
      .optionallyWith(
        conversationLogSettings.map(value => value.buildAwsValue())
      )(_.conversationLogSettings)
      .optionallyWith(
        sentimentAnalysisSettings.map(value => value.buildAwsValue())
      )(_.sentimentAnalysisSettings)
      .optionallyWith(
        botAliasHistoryEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botAliasHistoryEvents)
      .optionallyWith(botAliasStatus.map(value => value.unwrap))(
        _.botAliasStatus
      )
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        parentBotNetworks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parentBotNetworks)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeBotAliasResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeBotAliasResponse.wrap(buildAwsValue())
}
object DescribeBotAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeBotAliasResponse =
      zio.aws.lexmodelsv2.model.DescribeBotAliasResponse(
        botAliasId.map(value => value),
        botAliasName.map(value => value),
        description.map(value => value),
        botVersion.map(value => value),
        botAliasLocaleSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        conversationLogSettings.map(value => value.asEditable),
        sentimentAnalysisSettings.map(value => value.asEditable),
        botAliasHistoryEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        botAliasStatus.map(value => value),
        botId.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        parentBotNetworks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def botAliasId: Optional[BotAliasId]
    def botAliasName: Optional[Name]
    def description: Optional[Description]
    def botVersion: Optional[BotVersion]
    def botAliasLocaleSettings: Optional[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly]
    ]
    def conversationLogSettings
        : Optional[zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly]
    def sentimentAnalysisSettings
        : Optional[zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly]
    def botAliasHistoryEvents: Optional[
      List[zio.aws.lexmodelsv2.model.BotAliasHistoryEvent.ReadOnly]
    ]
    def botAliasStatus: Optional[zio.aws.lexmodelsv2.model.BotAliasStatus]
    def botId: Optional[Id]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def parentBotNetworks
        : Optional[List[zio.aws.lexmodelsv2.model.ParentBotNetwork.ReadOnly]]
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotAliasName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botAliasName", botAliasName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getBotAliasLocaleSettings: ZIO[Any, AwsError, Map[
      LocaleId,
      zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "botAliasLocaleSettings",
      botAliasLocaleSettings
    )
    def getConversationLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "conversationLogSettings",
      conversationLogSettings
    )
    def getSentimentAnalysisSettings: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sentimentAnalysisSettings",
      sentimentAnalysisSettings
    )
    def getBotAliasHistoryEvents: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotAliasHistoryEvent.ReadOnly
    ]] =
      AwsError.unwrapOptionField("botAliasHistoryEvents", botAliasHistoryEvents)
    def getBotAliasStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotAliasStatus] =
      AwsError.unwrapOptionField("botAliasStatus", botAliasStatus)
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getParentBotNetworks: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.ParentBotNetwork.ReadOnly
    ]] = AwsError.unwrapOptionField("parentBotNetworks", parentBotNetworks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeBotAliasResponse.ReadOnly {
    override val botAliasId: Optional[BotAliasId] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botAliasName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val botAliasLocaleSettings: Optional[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasLocaleSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.LocaleId(
              key
            ) -> zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.wrap(value)
          })
          .toMap
      )
    override val conversationLogSettings
        : Optional[zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationLogSettings())
        .map(value =>
          zio.aws.lexmodelsv2.model.ConversationLogSettings.wrap(value)
        )
    override val sentimentAnalysisSettings: Optional[
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sentimentAnalysisSettings())
      .map(value =>
        zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.wrap(value)
      )
    override val botAliasHistoryEvents: Optional[
      List[zio.aws.lexmodelsv2.model.BotAliasHistoryEvent.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasHistoryEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.BotAliasHistoryEvent.wrap(item)
        }.toList
      )
    override val botAliasStatus
        : Optional[zio.aws.lexmodelsv2.model.BotAliasStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botAliasStatus())
        .map(value => zio.aws.lexmodelsv2.model.BotAliasStatus.wrap(value))
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val parentBotNetworks
        : Optional[List[zio.aws.lexmodelsv2.model.ParentBotNetwork.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentBotNetworks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.ParentBotNetwork.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse
  ): zio.aws.lexmodelsv2.model.DescribeBotAliasResponse.ReadOnly = new Wrapper(
    impl
  )
}
