package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Id, BotAliasId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBotAliasResponse(
    botAliasId: Optional[BotAliasId] = Optional.Absent,
    botId: Optional[Id] = Optional.Absent,
    botAliasStatus: Optional[zio.aws.lexmodelsv2.model.BotAliasStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse = {
    import DeleteBotAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse
      .builder()
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(botAliasStatus.map(value => value.unwrap))(
        _.botAliasStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.wrap(buildAwsValue())
}
object DeleteBotAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteBotAliasResponse =
      zio.aws.lexmodelsv2.model.DeleteBotAliasResponse(
        botAliasId.map(value => value),
        botId.map(value => value),
        botAliasStatus.map(value => value)
      )
    def botAliasId: Optional[BotAliasId]
    def botId: Optional[Id]
    def botAliasStatus: Optional[zio.aws.lexmodelsv2.model.BotAliasStatus]
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotAliasStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotAliasStatus] =
      AwsError.unwrapOptionField("botAliasStatus", botAliasStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse
  ) extends zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.ReadOnly {
    override val botAliasId: Optional[BotAliasId] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botAliasStatus
        : Optional[zio.aws.lexmodelsv2.model.BotAliasStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botAliasStatus())
        .map(value => zio.aws.lexmodelsv2.model.BotAliasStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse
  ): zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.ReadOnly = new Wrapper(
    impl
  )
}
