package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, BotVersion, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDeleteCustomVocabularyItemRequest(
    botId: Id,
    botVersion: BotVersion,
    localeId: LocaleId,
    customVocabularyItemList: Iterable[
      zio.aws.lexmodelsv2.model.CustomVocabularyEntryId
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest = {
    import BatchDeleteCustomVocabularyItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(BotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .customVocabularyItemList(customVocabularyItemList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest
      .wrap(buildAwsValue())
}
object BatchDeleteCustomVocabularyItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest =
      zio.aws.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest(
        botId,
        botVersion,
        localeId,
        customVocabularyItemList.map { item =>
          item.asEditable
        }
      )
    def botId: Id
    def botVersion: BotVersion
    def localeId: LocaleId
    def customVocabularyItemList
        : List[zio.aws.lexmodelsv2.model.CustomVocabularyEntryId.ReadOnly]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, BotVersion] = ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getCustomVocabularyItemList: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.CustomVocabularyEntryId.ReadOnly
    ]] = ZIO.succeed(customVocabularyItemList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest
  ) extends zio.aws.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: BotVersion =
      zio.aws.lexmodelsv2.model.primitives.BotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val customVocabularyItemList
        : List[zio.aws.lexmodelsv2.model.CustomVocabularyEntryId.ReadOnly] =
      impl
        .customVocabularyItemList()
        .asScala
        .map { item =>
          zio.aws.lexmodelsv2.model.CustomVocabularyEntryId.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest
  ): zio.aws.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest.ReadOnly =
    new Wrapper(impl)
}
