package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait ImportFilterName {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.ImportFilterName
}
object ImportFilterName {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.ImportFilterName
  ): zio.aws.lexmodelsv2.model.ImportFilterName = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportFilterName.IMPORT_RESOURCE_TYPE =>
      val r = ImportResourceType
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.ImportFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object ImportResourceType
      extends zio.aws.lexmodelsv2.model.ImportFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportFilterName.IMPORT_RESOURCE_TYPE
  }
}
