package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait ExportFilterName {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterName
}
object ExportFilterName {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterName
  ): zio.aws.lexmodelsv2.model.ExportFilterName = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterName.EXPORT_RESOURCE_TYPE =>
      val r = ExportResourceType
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.ExportFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object ExportResourceType
      extends zio.aws.lexmodelsv2.model.ExportFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterName.EXPORT_RESOURCE_TYPE
  }
}
