package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{Timestamp, Id}
import scala.jdk.CollectionConverters._
final case class CreateExportResponse(
    exportId: Optional[Id] = Optional.Absent,
    resourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.ExportResourceSpecification
    ] = Optional.Absent,
    fileFormat: Optional[zio.aws.lexmodelsv2.model.ImportExportFileFormat] =
      Optional.Absent,
    exportStatus: Optional[zio.aws.lexmodelsv2.model.ExportStatus] =
      Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse = {
    import CreateExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse
      .builder()
      .optionallyWith(
        exportId.map(value => Id.unwrap(value): java.lang.String)
      )(_.exportId)
      .optionallyWith(
        resourceSpecification.map(value => value.buildAwsValue())
      )(_.resourceSpecification)
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(exportStatus.map(value => value.unwrap))(_.exportStatus)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateExportResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateExportResponse.wrap(buildAwsValue())
}
object CreateExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateExportResponse =
      zio.aws.lexmodelsv2.model.CreateExportResponse(
        exportId.map(value => value),
        resourceSpecification.map(value => value.asEditable),
        fileFormat.map(value => value),
        exportStatus.map(value => value),
        creationDateTime.map(value => value)
      )
    def exportId: Optional[Id]
    def resourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly
    ]
    def fileFormat: Optional[zio.aws.lexmodelsv2.model.ImportExportFileFormat]
    def exportStatus: Optional[zio.aws.lexmodelsv2.model.ExportStatus]
    def creationDateTime: Optional[Timestamp]
    def getExportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("exportId", exportId)
    def getResourceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("resourceSpecification", resourceSpecification)
    def getFileFormat
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ImportExportFileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getExportStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ExportStatus] =
      AwsError.unwrapOptionField("exportStatus", exportStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse
  ) extends zio.aws.lexmodelsv2.model.CreateExportResponse.ReadOnly {
    override val exportId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.exportId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val resourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.ExportResourceSpecification.wrap(value)
      )
    override val fileFormat
        : Optional[zio.aws.lexmodelsv2.model.ImportExportFileFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileFormat())
        .map(value =>
          zio.aws.lexmodelsv2.model.ImportExportFileFormat.wrap(value)
        )
    override val exportStatus
        : Optional[zio.aws.lexmodelsv2.model.ExportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportStatus())
        .map(value => zio.aws.lexmodelsv2.model.ExportStatus.wrap(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse
  ): zio.aws.lexmodelsv2.model.CreateExportResponse.ReadOnly = new Wrapper(impl)
}
