package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DateRangeFilter(
    startDateTime: Timestamp,
    endDateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DateRangeFilter = {
    import DateRangeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DateRangeFilter
      .builder()
      .startDateTime(Timestamp.unwrap(startDateTime): Instant)
      .endDateTime(Timestamp.unwrap(endDateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DateRangeFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.DateRangeFilter.wrap(buildAwsValue())
}
object DateRangeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DateRangeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DateRangeFilter =
      zio.aws.lexmodelsv2.model.DateRangeFilter(startDateTime, endDateTime)
    def startDateTime: Timestamp
    def endDateTime: Timestamp
    def getStartDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(startDateTime)
    def getEndDateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DateRangeFilter
  ) extends zio.aws.lexmodelsv2.model.DateRangeFilter.ReadOnly {
    override val startDateTime: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.startDateTime())
    override val endDateTime: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.endDateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DateRangeFilter
  ): zio.aws.lexmodelsv2.model.DateRangeFilter.ReadOnly = new Wrapper(impl)
}
