package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PostFulfillmentStatusSpecification(
    successResponse: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent,
    failureResponse: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent,
    timeoutResponse: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent,
    successNextStep: Optional[zio.aws.lexmodelsv2.model.DialogState] =
      Optional.Absent,
    successConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification
    ] = Optional.Absent,
    failureNextStep: Optional[zio.aws.lexmodelsv2.model.DialogState] =
      Optional.Absent,
    failureConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification
    ] = Optional.Absent,
    timeoutNextStep: Optional[zio.aws.lexmodelsv2.model.DialogState] =
      Optional.Absent,
    timeoutConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.PostFulfillmentStatusSpecification = {
    import PostFulfillmentStatusSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.PostFulfillmentStatusSpecification
      .builder()
      .optionallyWith(successResponse.map(value => value.buildAwsValue()))(
        _.successResponse
      )
      .optionallyWith(failureResponse.map(value => value.buildAwsValue()))(
        _.failureResponse
      )
      .optionallyWith(timeoutResponse.map(value => value.buildAwsValue()))(
        _.timeoutResponse
      )
      .optionallyWith(successNextStep.map(value => value.buildAwsValue()))(
        _.successNextStep
      )
      .optionallyWith(successConditional.map(value => value.buildAwsValue()))(
        _.successConditional
      )
      .optionallyWith(failureNextStep.map(value => value.buildAwsValue()))(
        _.failureNextStep
      )
      .optionallyWith(failureConditional.map(value => value.buildAwsValue()))(
        _.failureConditional
      )
      .optionallyWith(timeoutNextStep.map(value => value.buildAwsValue()))(
        _.timeoutNextStep
      )
      .optionallyWith(timeoutConditional.map(value => value.buildAwsValue()))(
        _.timeoutConditional
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification
      .wrap(buildAwsValue())
}
object PostFulfillmentStatusSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.PostFulfillmentStatusSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification =
      zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification(
        successResponse.map(value => value.asEditable),
        failureResponse.map(value => value.asEditable),
        timeoutResponse.map(value => value.asEditable),
        successNextStep.map(value => value.asEditable),
        successConditional.map(value => value.asEditable),
        failureNextStep.map(value => value.asEditable),
        failureConditional.map(value => value.asEditable),
        timeoutNextStep.map(value => value.asEditable),
        timeoutConditional.map(value => value.asEditable)
      )
    def successResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def failureResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def timeoutResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def successNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly]
    def successConditional
        : Optional[zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly]
    def failureNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly]
    def failureConditional
        : Optional[zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly]
    def timeoutNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly]
    def timeoutConditional
        : Optional[zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly]
    def getSuccessResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("successResponse", successResponse)
    def getFailureResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("failureResponse", failureResponse)
    def getTimeoutResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("timeoutResponse", timeoutResponse)
    def getSuccessNextStep
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      AwsError.unwrapOptionField("successNextStep", successNextStep)
    def getSuccessConditional: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("successConditional", successConditional)
    def getFailureNextStep
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      AwsError.unwrapOptionField("failureNextStep", failureNextStep)
    def getFailureConditional: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("failureConditional", failureConditional)
    def getTimeoutNextStep
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      AwsError.unwrapOptionField("timeoutNextStep", timeoutNextStep)
    def getTimeoutConditional: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("timeoutConditional", timeoutConditional)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PostFulfillmentStatusSpecification
  ) extends zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.ReadOnly {
    override val successResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
    override val failureResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
    override val timeoutResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
    override val successNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successNextStep())
        .map(value => zio.aws.lexmodelsv2.model.DialogState.wrap(value))
    override val successConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.successConditional())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConditionalSpecification.wrap(value)
      )
    override val failureNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureNextStep())
        .map(value => zio.aws.lexmodelsv2.model.DialogState.wrap(value))
    override val failureConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failureConditional())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConditionalSpecification.wrap(value)
      )
    override val timeoutNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutNextStep())
        .map(value => zio.aws.lexmodelsv2.model.DialogState.wrap(value))
    override val timeoutConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutConditional())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConditionalSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PostFulfillmentStatusSpecification
  ): zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.ReadOnly =
    new Wrapper(impl)
}
