package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AllowedInputTypes(
    allowAudioInput: BoxedBoolean,
    allowDTMFInput: BoxedBoolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AllowedInputTypes = {
    import AllowedInputTypes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AllowedInputTypes
      .builder()
      .allowAudioInput(allowAudioInput: java.lang.Boolean)
      .allowDTMFInput(allowDTMFInput: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AllowedInputTypes.ReadOnly =
    zio.aws.lexmodelsv2.model.AllowedInputTypes.wrap(buildAwsValue())
}
object AllowedInputTypes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AllowedInputTypes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AllowedInputTypes =
      zio.aws.lexmodelsv2.model
        .AllowedInputTypes(allowAudioInput, allowDTMFInput)
    def allowAudioInput: BoxedBoolean
    def allowDTMFInput: BoxedBoolean
    def getAllowAudioInput: ZIO[Any, Nothing, BoxedBoolean] =
      ZIO.succeed(allowAudioInput)
    def getAllowDTMFInput: ZIO[Any, Nothing, BoxedBoolean] =
      ZIO.succeed(allowDTMFInput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AllowedInputTypes
  ) extends zio.aws.lexmodelsv2.model.AllowedInputTypes.ReadOnly {
    override val allowAudioInput: BoxedBoolean =
      impl.allowAudioInput(): BoxedBoolean
    override val allowDTMFInput: BoxedBoolean =
      impl.allowDTMFInput(): BoxedBoolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AllowedInputTypes
  ): zio.aws.lexmodelsv2.model.AllowedInputTypes.ReadOnly = new Wrapper(impl)
}
