package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Id, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBotAliasesResponse(
    botAliasSummaries: Optional[
      Iterable[zio.aws.lexmodelsv2.model.BotAliasSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    botId: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse = {
    import ListBotAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse
      .builder()
      .optionallyWith(
        botAliasSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botAliasSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListBotAliasesResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBotAliasesResponse.wrap(buildAwsValue())
}
object ListBotAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBotAliasesResponse =
      zio.aws.lexmodelsv2.model.ListBotAliasesResponse(
        botAliasSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        botId.map(value => value)
      )
    def botAliasSummaries
        : Optional[List[zio.aws.lexmodelsv2.model.BotAliasSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def botId: Optional[Id]
    def getBotAliasSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotAliasSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("botAliasSummaries", botAliasSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse
  ) extends zio.aws.lexmodelsv2.model.ListBotAliasesResponse.ReadOnly {
    override val botAliasSummaries
        : Optional[List[zio.aws.lexmodelsv2.model.BotAliasSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botAliasSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.BotAliasSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse
  ): zio.aws.lexmodelsv2.model.ListBotAliasesResponse.ReadOnly = new Wrapper(
    impl
  )
}
