package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait BotFilterName {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.BotFilterName
}
object BotFilterName {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.BotFilterName
  ): zio.aws.lexmodelsv2.model.BotFilterName = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.BotFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.BotFilterName.BOT_NAME =>
      val r = BotName
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.BotFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.BotFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.BotFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object BotName extends zio.aws.lexmodelsv2.model.BotFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.BotFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.BotFilterName.BOT_NAME
  }
}
