package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LogPrefix, S3BucketArn, KmsKeyArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3BucketLogDestination(
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent,
    s3BucketArn: S3BucketArn,
    logPrefix: LogPrefix
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.S3BucketLogDestination = {
    import S3BucketLogDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.S3BucketLogDestination
      .builder()
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .s3BucketArn(S3BucketArn.unwrap(s3BucketArn): java.lang.String)
      .logPrefix(LogPrefix.unwrap(logPrefix): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.S3BucketLogDestination.ReadOnly =
    zio.aws.lexmodelsv2.model.S3BucketLogDestination.wrap(buildAwsValue())
}
object S3BucketLogDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.S3BucketLogDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.S3BucketLogDestination =
      zio.aws.lexmodelsv2.model.S3BucketLogDestination(
        kmsKeyArn.map(value => value),
        s3BucketArn,
        logPrefix
      )
    def kmsKeyArn: Optional[KmsKeyArn]
    def s3BucketArn: S3BucketArn
    def logPrefix: LogPrefix
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getS3BucketArn: ZIO[Any, Nothing, S3BucketArn] =
      ZIO.succeed(s3BucketArn)
    def getLogPrefix: ZIO[Any, Nothing, LogPrefix] = ZIO.succeed(logPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.S3BucketLogDestination
  ) extends zio.aws.lexmodelsv2.model.S3BucketLogDestination.ReadOnly {
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.KmsKeyArn(value))
    override val s3BucketArn: S3BucketArn =
      zio.aws.lexmodelsv2.model.primitives.S3BucketArn(impl.s3BucketArn())
    override val logPrefix: LogPrefix =
      zio.aws.lexmodelsv2.model.primitives.LogPrefix(impl.logPrefix())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.S3BucketLogDestination
  ): zio.aws.lexmodelsv2.model.S3BucketLogDestination.ReadOnly = new Wrapper(
    impl
  )
}
