package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Message(
    plainTextMessage: Optional[zio.aws.lexmodelsv2.model.PlainTextMessage] =
      Optional.Absent,
    customPayload: Optional[zio.aws.lexmodelsv2.model.CustomPayload] =
      Optional.Absent,
    ssmlMessage: Optional[zio.aws.lexmodelsv2.model.SSMLMessage] =
      Optional.Absent,
    imageResponseCard: Optional[zio.aws.lexmodelsv2.model.ImageResponseCard] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.Message = {
    import Message.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.Message
      .builder()
      .optionallyWith(plainTextMessage.map(value => value.buildAwsValue()))(
        _.plainTextMessage
      )
      .optionallyWith(customPayload.map(value => value.buildAwsValue()))(
        _.customPayload
      )
      .optionallyWith(ssmlMessage.map(value => value.buildAwsValue()))(
        _.ssmlMessage
      )
      .optionallyWith(imageResponseCard.map(value => value.buildAwsValue()))(
        _.imageResponseCard
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.Message.ReadOnly =
    zio.aws.lexmodelsv2.model.Message.wrap(buildAwsValue())
}
object Message {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.Message
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.Message =
      zio.aws.lexmodelsv2.model.Message(
        plainTextMessage.map(value => value.asEditable),
        customPayload.map(value => value.asEditable),
        ssmlMessage.map(value => value.asEditable),
        imageResponseCard.map(value => value.asEditable)
      )
    def plainTextMessage
        : Optional[zio.aws.lexmodelsv2.model.PlainTextMessage.ReadOnly]
    def customPayload
        : Optional[zio.aws.lexmodelsv2.model.CustomPayload.ReadOnly]
    def ssmlMessage: Optional[zio.aws.lexmodelsv2.model.SSMLMessage.ReadOnly]
    def imageResponseCard
        : Optional[zio.aws.lexmodelsv2.model.ImageResponseCard.ReadOnly]
    def getPlainTextMessage: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.PlainTextMessage.ReadOnly
    ] = AwsError.unwrapOptionField("plainTextMessage", plainTextMessage)
    def getCustomPayload
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.CustomPayload.ReadOnly] =
      AwsError.unwrapOptionField("customPayload", customPayload)
    def getSsmlMessage
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.SSMLMessage.ReadOnly] =
      AwsError.unwrapOptionField("ssmlMessage", ssmlMessage)
    def getImageResponseCard: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ImageResponseCard.ReadOnly
    ] = AwsError.unwrapOptionField("imageResponseCard", imageResponseCard)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.Message
  ) extends zio.aws.lexmodelsv2.model.Message.ReadOnly {
    override val plainTextMessage
        : Optional[zio.aws.lexmodelsv2.model.PlainTextMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.plainTextMessage())
        .map(value => zio.aws.lexmodelsv2.model.PlainTextMessage.wrap(value))
    override val customPayload
        : Optional[zio.aws.lexmodelsv2.model.CustomPayload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customPayload())
        .map(value => zio.aws.lexmodelsv2.model.CustomPayload.wrap(value))
    override val ssmlMessage
        : Optional[zio.aws.lexmodelsv2.model.SSMLMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssmlMessage())
        .map(value => zio.aws.lexmodelsv2.model.SSMLMessage.wrap(value))
    override val imageResponseCard
        : Optional[zio.aws.lexmodelsv2.model.ImageResponseCard.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageResponseCard())
        .map(value => zio.aws.lexmodelsv2.model.ImageResponseCard.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.Message
  ): zio.aws.lexmodelsv2.model.Message.ReadOnly = new Wrapper(impl)
}
