package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.RegexPattern
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SlotValueRegexFilter(pattern: RegexPattern) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotValueRegexFilter = {
    import SlotValueRegexFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotValueRegexFilter
      .builder()
      .pattern(RegexPattern.unwrap(pattern): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotValueRegexFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotValueRegexFilter.wrap(buildAwsValue())
}
object SlotValueRegexFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotValueRegexFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotValueRegexFilter =
      zio.aws.lexmodelsv2.model.SlotValueRegexFilter(pattern)
    def pattern: RegexPattern
    def getPattern: ZIO[Any, Nothing, RegexPattern] = ZIO.succeed(pattern)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotValueRegexFilter
  ) extends zio.aws.lexmodelsv2.model.SlotValueRegexFilter.ReadOnly {
    override val pattern: RegexPattern =
      zio.aws.lexmodelsv2.model.primitives.RegexPattern(impl.pattern())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotValueRegexFilter
  ): zio.aws.lexmodelsv2.model.SlotValueRegexFilter.ReadOnly = new Wrapper(impl)
}
