package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{BoxedBoolean, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DialogAction(
    `type`: zio.aws.lexmodelsv2.model.DialogActionType,
    slotToElicit: Optional[Name] = Optional.Absent,
    suppressNextMessage: Optional[BoxedBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DialogAction = {
    import DialogAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DialogAction
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        slotToElicit.map(value => Name.unwrap(value): java.lang.String)
      )(_.slotToElicit)
      .optionallyWith(
        suppressNextMessage.map(value => value: java.lang.Boolean)
      )(_.suppressNextMessage)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DialogAction.ReadOnly =
    zio.aws.lexmodelsv2.model.DialogAction.wrap(buildAwsValue())
}
object DialogAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DialogAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DialogAction =
      zio.aws.lexmodelsv2.model.DialogAction(
        `type`,
        slotToElicit.map(value => value),
        suppressNextMessage.map(value => value)
      )
    def `type`: zio.aws.lexmodelsv2.model.DialogActionType
    def slotToElicit: Optional[Name]
    def suppressNextMessage: Optional[BoxedBoolean]
    def getType: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.DialogActionType] =
      ZIO.succeed(`type`)
    def getSlotToElicit: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicit)
    def getSuppressNextMessage: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("suppressNextMessage", suppressNextMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DialogAction
  ) extends zio.aws.lexmodelsv2.model.DialogAction.ReadOnly {
    override val `type`: zio.aws.lexmodelsv2.model.DialogActionType =
      zio.aws.lexmodelsv2.model.DialogActionType.wrap(impl.`type`())
    override val slotToElicit: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.slotToElicit())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val suppressNextMessage: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressNextMessage())
        .map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DialogAction
  ): zio.aws.lexmodelsv2.model.DialogAction.ReadOnly = new Wrapper(impl)
}
